/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2010,2012 COLLARD Christophe
 * copyright © 2006 PARGUEZ Cristelle
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2010,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2010 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    isotropic tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type isotropic tensors test
#endif

#ifndef __isotropic_tensors_test_hpp
#define __isotropic_tensors_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __symtensors4_hpp
#include "MOL++/symtensors4.hpp"
#endif

#ifndef __isotropic_tensors_hpp
#include "MateriOL++/isotropic tensors.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//====================================
int test_isotropic_tensor (int detail)
//====================================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                 isotropic tensor test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  long double lambda=60000, mu=40000;
  isotropic_tensor<long double> C("elasticity tensor"), S, C0(lambda,mu), C1, C2, Cx, Cxx;
  C.lambda(lambda);
  C.mu(mu);

  tensor4<long double> Ct(3), St(3);

  if (detail) affiche ("material constants", C.lambda()==60000 && C.mu()==40000);
  else result *= (C.lambda()==60000 && C.mu()==40000);
  bool test = true;

  vector<long double> lame(2);
  lame[1] = C.lambda();
  lame[2] = C.mu();
  if (detail) affiche ("elastic constants", C.elastic_constants() == lame);
  else result *= (C.elastic_constants() == lame);

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= (C(i,j,k,l) == lambda * (i==j) * (k==l) + mu * ( (i==k) * (j==l) + (i==l) * (j==k) ) );
  if (detail) affiche ("operator (,,,)", test);
  else result *= (test);

  tensor4<long double> T;
  T = C;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= (T(i,j,k,l) == C(i,j,k,l));

  if (detail) affiche ("cast operator () isotropic_tensor -> tensor4", test);
  else result *= (test);

  symtensor4<long double> ST;
  ST  = C;
  if (detail) affiche ("cast operator () isotropic_tensor -> symtensor4", ST == T);
  else result *= (ST==T);

  isotropic_tensor <long double> C3(2000,3000), C4(4572,5507);
  tensor4 <long double> T3, T4;
  T3 = C3;
  T4 = C4;

  test = (C3==C3) && !(C3==C4);
  if (detail) affiche ("operator ==", test);
  else result *= (test);

  test = (C3==T3) && !(C3==T4);
  if (detail) affiche ("operator == (isotropic_tensor/tensor4)", test);
  else result *= (test);

  test = (T3==C3) && !(T3==C4);
  if (detail) affiche ("operator == (tensor4/isotropic_tensor)", test);
  else result *= (test);

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  {
	    Ct(i,j,k,l) = lambda * (i==j) * (k==l) + mu * ( (i==k) * (j==l) + (i==l) * (j==k));
	    test *= (abs( C(i,j,k,l) - lambda * (i==j) * (k==l) - mu * ( (i==k) * (j==l) + (i==l) * (j==k)) ) < epsilon);
	  }

  test *= (Ct == C0);

  vector<long double> vl(2);
  vl[1] = lambda;
  vl[2] = mu;
  isotropic_tensor<long double> Cv(vl,"elasticity tensor");
  test *= (C==Cv);
  if (detail) affiche ("constructors", test);
  else result *= (test);

  isotropic_tensor<long double> iso(C3);
  test *= (iso == C3);
  if (detail) affiche ("copy constructor", test);
  else result *= (test);

  isotropic_tensor<long double> R1(50000,6000,"isotropic tensor"), R2(20000,60000);
  R2.name("isotropic");
  test *= ((R1.name() == "isotropic tensor") && (R2.name() == "isotropic"));
  if (detail) affiche ("name", test);
  else result *= (test);

  tensor4<long double> Tsr(3,3,3,3);
  isotropic_tensor<long double> Iso(5000,8000);
  Tsr=Iso;
  isotropic_tensor<long double> Iso1(Tsr,"tensor test");
  isotropic_tensor<long double> Iso2;
  Iso2=Tsr;
  if (detail) affiche ("cast convertion tensor4 -> isotropic_tensor", Iso==Iso1 && Iso==Iso2 );
  else result *= (Iso==Iso1 && Iso==Iso2 );

  tensor4<long double> STsr(3,3,3,3);
  Tsr=Iso;
  isotropic_tensor<long double> Iso3;
  Iso3=Tsr;
  if (detail) affiche ("cast convertion tensor4 -> isotropic_tensor", Iso==Iso3);
  else result *= (Iso==Iso3);

  test = (Ct == C);
  test *= (C.mu()== mu && C.lambda() == lambda);
  lambda *= 2;
  isotropic_tensor<long double> I1(lambda,mu);
  C0.lambda(lambda);
  test *= (C0 == I1);
  test *= (I1 != C);
  if (detail) affiche ("lambda", test);
  else result *= (test);

  mu *= 3;
  isotropic_tensor<long double> I2(lambda,mu);
  C0.mu(mu);
  test = (C0 == I2);
  if (detail) affiche ("mu", test);
  else result *= (test);


  //===============
  // operator tests
  //===============


  isotropic_tensor<long double> c1(0,2000), c2(5000,0), c3(0,0);
  test *= (!C3 == false) && (!c1 == true) && (!c2 == true) && (!c3 == true);
  if (detail) affiche ("operator !", test);
  else result *= (test);

  Cxx = C;
  Cx = Cxx;
  Cxx.name("iso tensor");
  if (detail) affiche ("operator =", Cx == C);
  else result *= (Cx == C);

  tensor3<long double> t;

  if (detail) affiche ("operator []", T[1] == C[1]);
  else result *= (T[1] == C[1]);

  test = (T3==C3 && T4==C4);
  test *= T3+T4 == C3+C4;
  if (detail) affiche ("operator +", test);
  else result *= (test);

  test = (T3==C3 && T4==C4);
  test *= T3-T4 == C3-C4;
  if (detail) affiche ("operator -", test);
  else result *= (test);

  test = (T3==C3 && T4==C4);
  test *= (T3|T4) == (C3|C4);
  if (detail) affiche ("operator |", test);
  else result *= (test);

  test = (T3==C3 && T4==C4);
  test *= (T3||T4) == (C3||C4);
  if (detail) affiche ("operator ||", test);
  else result *= (test);

  test = (T3==C3 && T4==C4);
  C3+=C4;
  T3+=T4;
  test *= (T3 == C3);
  if (detail) affiche ("operator +=", test);
  else result *= (test);

  test = (T3==C3 && T4==C4);
  C3-=C4;
  T3-=T4;
  test *= (T3 == C3);
  if (detail) affiche ("operator -=", test);
  else result *= (test);

  test = !(C3!=C3) && (C3!=C4);
  if (detail) affiche ("operator !=", test);
  else result *= (test);


  //========================
  // operations with scalars
  //========================


  test = (T3==C3);
  test *= (T3*(long double)5) == (C3*(long double)5);
  if (detail) affiche ("operator * (isotropic_tensor/scalar)", test);
  else result *= (test);

  test = (T3==C3);
  test *= ((long double)3*T3) == ((long double)3*C3);
  if (detail) affiche ("operator * (scalar/isotropic_tensor)", test);
  else result *= (test);

  test = (T3==C3);
  C3*=2;
  T3*=2;
  test *= (T3==C3);
  if (detail) affiche ("operator *= (isotropic_tensor/scalar)", test);
  else result *= (test);


  //========================
  // operations with vectors
  //========================


  vector<long double> v(3);
  for (int k=1; k<=3; k++) v[k] = 0.125*k;
  v[2] -= 2;

  test = (T3==C3);
  test *= (C3*v)==(T3*v);
  if (detail) affiche ("operator * (isotropic_tensor/vector)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (v*C3)==(v*T3);
  if (detail) affiche ("operator * (vector/isotropic_tensor)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (C3|v)==(T3|v);
  if (detail) affiche ("operator | (isotropic_tensor/vector)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (v|C3)==(v|T3);
  if (detail) affiche ("operator | (vector/isotropic_tensor)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (tensor_sum(C3,v,1) == tensor_sum(T3,v,1))  &&  (tensor_sum(C3,v,2) == tensor_sum(T3,v,2))  &&  (tensor_sum(C3,v,3) == tensor_sum(T3,v,3)) &&  (tensor_sum(C3,v,4) == tensor_sum(T3,v,4));
  if (detail) affiche ("sum tensor * vector (i), i = 1->4 :", test);
  else result *= (test);


  //=================================
  // operation with 2nd order tensors
  //=================================


  tensor2<long double> t2s(3,3,false);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      t2s(i,j) = i*i - 2*j;

  test = (T3==C3);
  test *= (C3||t2s)==(T3||t2s);
  if (detail) affiche ("operator || (isotropic_tensor/tenor2)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (t2s||C3)==(t2s||T3);
  if (detail) affiche ("operator || (tensor2/isotropic_tensor)", test);
  else result *= (test);


  //=================================
  // operation with 3rd order tensors
  //=================================


  tensor3<long double> t3s(3,3,3,false);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	t3s(i,j,k) = 3*k/i + 2*j/k;

  test = (T3==C3);
  test *= (C3||t3s)==(T3||t3s);
  if (detail) affiche ("operator || (isotropic_tensor/tensor3)", test);
  else result *= (test);

  test = (T3==C3);
  test *= (t3s||C3)==(t3s||T3);
  if (detail) affiche ("operator || (tensor3/isotropic_tensor)", test);
  else result *= (test);


  //=================================
  // operation with 4th order tensors
  //=================================


  tensor4<long double> t4s (3,3,3,3,false);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
        for (int l=1; l<=3; l++)
	t4s(i,j,k,l) = 3*k/i + 2*j/k - l;
  t4s[2] = t3s;

  test = (T4==C4);
  test *= C4+t4s == T4+t4s;
  if (detail) affiche ("operator + (isotropic_tensor/tensor4)", test);
  else result *= (test);

  test = (T4==C4);
  test *= t4s+C4 == t4s+T4;
  if (detail) affiche ("operator + (tensor4/isotropic_tensor)", test);
  else result *= (test);

  test = (T4==C4);
  test *= C4-t4s == T4-t4s;
  if (detail) affiche ("operator - (isotropic_tensor/tensor4)", test);
  else result *= (test);

  test = (T4==C4);
  test *= t4s-C4 == t4s-T4;
  if (detail) affiche ("operator - (tensor4/isotropic_tensor)", test);
  else result *= (test);

  test = (T4==C4);
  test *= (C4|t4s) == (T4|t4s);
  if (detail) affiche ("operator | (isotropic_tensor/tensor4)", test);
  else result *= (test);

  test = (T4==C4);
  test *= (t4s|C4) == (t4s|T4);
  if (detail) affiche ("operator | (tensor4/isotropic_tensor)", test);
  else result *= (test);

  test = (T4==C4);
  test *= (C4||t4s) == (T4||t4s);
  if (detail) affiche ("operator || (isotropic_tensor/tensor4)", test);
  else result *= (test);

  test = (T4==C4);
  test *= (t4s||C4) == (t4s||T4);
  if (detail) affiche ("operator || (tensor4/isotropic_tensor)", test);
  else result *= (test);

  test = (T3==C3);
  test = !(C3!=T3) && (C3!=t4s);
  if (detail) affiche ("operator != (isotropic_tensor/tensor4)", test);
  else result *= (test);  

  test = (T3==C3);
  test = !(T3!=C3) && (t4s!=C3);
  if (detail) affiche ("operator != (tensor4/isotropic_tensor)", test);
  else result *= (test);


  //===========================
  // operations with symtensor4
  //===========================


  symtensor4<long double> ST4 (3);
  for (int i=1; i<=3; i++)
    for (int j=i; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=k; l<=3; l++)
	  ST4 (i,j,k,l) = 2 * (i + j) / (k * l);
  if (detail) affiche ("operator + (isotropic_tensor/symtensor4)", T4+ST4 == C4+ST4);
  else result *= (T4+ST4 == C4+ST4);

  if (detail) affiche ("operator + (symtensor4/isotropic_tensor)", T4+ST4 == ST4+C4);
  else result *= (T4+ST4 == ST4+C4);

  if (detail) affiche ("operator - (isotropic_tensor/symtensor4)", T4-ST4 == C4-ST4);
  else result *= (T4-ST4 == C4-ST4);

  if (detail) affiche ("operator - (symtensor4/isotropic_tensor)", ST4-T4 == ST4-C4);
  else result *= (ST4-T4 == ST4-C4);

  if (detail) affiche ("operator | (isotropic_tensor/symtensor4)", (T4|ST4) == (C4|ST4));
  else result *= ((T4|ST4) == (C4|ST4));

  if (detail) affiche ("operator | (symtensor4/isotropic_tensor)", (ST4|T4) == (ST4|C4));
  else result *= ((ST4|T4) == (ST4|C4));

  if (detail) affiche ("operator || (isotropic_tensor/symtensor4)", (T4||ST4) == (C4||ST4));
  else result *= ((T4||ST4) == (C4||ST4));

  if (detail) affiche ("operator || (symtensor4/isotropic_tensor)", (ST4||T4) == (ST4||C4));
  else result *= ((ST4||T4) == (ST4||C4));

  symtensor4<long double> ST44 = C4;
  test = !(C4!=ST44) && (C4!=ST4);
  if (detail) affiche ("operator == != (isotropic_tensor/symtensor4)", test);
  else result *= (test);  

  test = !(ST44!=C4) && (ST4!=C4);
  if (detail) affiche ("operator == != (symtensor4/isotropic_tensor)", test);
  else result *= (test);


  S = C0;
  S.name("stiffness tensor");
  S.lambda(-1.*lambda/(2*mu)/(3*lambda+2*mu));
  S.mu(1/(4*mu));
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  St(i,j,k,l) = 0.25 / mu * ( (i==k) * (j==l) + (i==l) * (j==k) ) - lambda / (2.*mu * (3.*lambda + 2.*mu)) * (i==j) * (k==l);
  if (detail) affiche ("isotropic stiffness tensor", St==S && S==C0.inv());
  else result *= (St==S && S==C0.inv());

  matrix<long double> P(3,3);
  matrix<long double> passlg(3,3); // orthogonal matrix
  tensor4<long double> tsr(3);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      P(i,j) = (2.52*i - 1.25*j + 25 * (i==j)) * 1E-2;
  long double phi1=173.464, phi=104.504, phi2=34.5;
  passlg(1,1) =  cos(phi1) * cos(phi2)  -  sin(phi1) * cos(phi) * sin(phi2);
  passlg(1,2) = -cos(phi1) * sin(phi2)  -  sin(phi1) * cos(phi) * cos(phi2);
  passlg(1,3) =  sin(phi1) * sin(phi);
  passlg(2,1) =  sin(phi1) * cos(phi2)  +  cos(phi1) * cos(phi) * sin(phi2);
  passlg(2,2) = -sin(phi1) * sin(phi2)  +  cos(phi1) * cos(phi) * cos(phi2);
  passlg(2,3) = -cos(phi1) * sin(phi);
  passlg(3,1) =  sin(phi)  * sin(phi2);
  passlg(3,2) =  sin(phi)  * cos(phi2);
  passlg(3,3) =  cos(phi);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  for (int p=1; p<=3; p++)
	    for (int q=1; q<=3; q++)
	      for (int m=1; m<=3; m++)
		for (int n=1; n<=3; n++)
		  tsr(p,q,m,n) += P(p,i) * P(q,j) * P(m,k) * P(n,l) * C(i,j,k,l);
  long double scalar = .01;
  test = true;
  test *= (C == change_orthonormal_basis(passlg,C));
  test *= (C*scalar == change_basis(passlg,C)*scalar);
  test *= (tsr == change_basis(P,C));
  if (detail) affiche ("change basis", test);
  else result *= test;

  C.save ("isotropic tensor.res");
  C0.read ("isotropic tensor.res");
  isotropic_tensor<long double> Ciso;
  Ciso.lambda(20000);
  Ciso.mu(1000);
  Ciso.save ("iso.res");
  Cxx.read("iso.res");

  if (detail) affiche ("read / write", C==C0 && Ciso==Cxx);
  else result *= (C==C0 && Ciso==Cxx);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                 isotropic tensor test passed" << reset;
  else cout << red << "                 isotropic tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
